<?php

use yii\grid\GridView;
use yii\helpers\Html;
use yii\helpers\Url;
use yii\web\View;
use yii\widgets\Pjax;
use yii\helpers\ArrayHelper;

/**
 * @var yii\web\View $this
 * @var yii\data\ActiveDataProvider $dataProvider
 * @var dektrium\user\models\UserSearch $searchModel
 */
$this->title = Yii::t('user', 'Users List');
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="col-xs-12">
  <div class="col-lg-8 col-sm-8 col-xs-12 no-padding"><h3 class="box-title"><i class="fa fa-th-list"></i> <?php echo Yii::t('user', 'User List') ?></h3></div>
  <div class="col-lg-4 col-sm-4 col-xs-12 no-padding" style="padding-top: 20px !important;">
	<div class="col-xs-4 left-padding">
	</div>
	<div class="col-xs-4 left-padding">
	</div>
	<div class="col-xs-4 left-padding">

	</div>
  </div>
</div>
<div class="col-xs-12" style="padding-top: 10px;">
   <div class="box">
     <div class="box-body table-responsive">
	   <div class="index">
	     <?php Pjax::begin() ?>
                <?=
                GridView::widget([
                    'dataProvider' => $dataProvider,
                    'filterModel' => $searchModel,
                    'layout' => '{items}{summary}{pager}',
                    'columns' => [
                        'name',
                        'phoneno',
                        [
                            'header' => 'Email',
                            'attribute' => 'email',
                            'value' => function ($model, $key, $index, $widget) {
                                return $model->email;
                            },
                            'format' => 'raw',
                        ],
                        [
                            'header' => 'Registration On',
                            'attribute' => 'created_at',
                            'filter' => '',
                            'value' => function ($model) {
                                return Yii::t('user', '{0, date,dd MMMM, YYYY}', [$model->created_at]);
                            },
                                    'contentOptions' => ['style' => 'width: 200px;']
                                ],
						 [
							'header' => Yii::t('user', 'Roles'),
							'value' => function ($model) {
								$ro = '';
								$roles = \Yii::$app->authManager->getRolesByUser($model->id);
								if (!empty($roles)) {
									foreach ($roles as $r) {
										$ro.= $r->description . ',';
									}
								}
								return trim($ro, ',');
							},
							'format' => 'raw',
							'contentOptions' => ['style' => 'width: 100px;']
						],
						[
						'class' => 'yii\grid\ActionColumn',
						'template' => '{up}',
						'buttons' => [
							'up' => function ($url, $model) {
								return Html::a('<span class="btn btn-xs btn-primary fa fa-edit"></span>', ['/user/update', 'id' => $model->id], ['data-pjax' => '0',
											'title' => Yii::t('user', 'Update'),
								]);
							},
								],
								'contentOptions' => ['style' => 'width: 50px;']
							],
						],
					]);
					?>
				<?php Pjax::end() ?>
			</div>
     </div>
   </div>
</div>								
