<?php
use yii\helpers\Html;
use yii\widgets\ActiveForm;
use yii\widgets\MaskedInput;
use kartik\nav\NavX;
use frontend\assets\AppAsset;

AppAsset::register($this);
$this->title = 'Sign up now';
\Yii::$app->view->registerMetaTag([
    'name' => 'description',
    'content' => 'Sign up now',
]);
\Yii::$app->view->registerMetaTag([
    'name' => 'keywords',
    'content' => 'Sign up now',
]);
?>
<!-- Breadcrumb Area start -->
<section class="breadcrumb-area">
	<div class="container">
		<div class="row">
			<div class="col-md-12">
				<div class="breadcrumb-content">
					<h1 class="breadcrumb-hrading">Register</h1>
					<ul class="breadcrumb-links">
						<li><?= Html::a("Home",['/site/index'])  ?></li>
						<li>Register</li>
					</ul>
				</div>
			</div>
		</div>
	</div>
</section>
<!-- Breadcrumb Area End -->
<!-- login area start -->
<div class="login-register-area mb-60px mt-53px">
	<div class="container">
		<div class="row">
			<div class="col-lg-7 col-md-12 mx-auto">
				<div class="login-register-wrapper">
					<div class="login-register-tab-list nav">
					    <?=Html::a("<h4> Login </h4>",['/security/login']) ?>
						<a class="active" data-bs-toggle="tab" href="#lg2">
							<h4>register</h4>
						</a>
					</div>
					<div class="tab-content">
						<div id="lg2" class="tab-pane active">
							<div class="login-form-container">
								<div class="login-register-form">
								  <?php $form = ActiveForm::begin([
										'id' => 'registration-form',
										'enableAjaxValidation' => true,
										'enableClientValidation' => false,
									]); ?>
										<?= $form->field($model, 'name')->textInput(['placeholder' => 'Full Name'])->label(false) ?>
										<?= $form->field($model, 'email')->textInput(['placeholder' => 'Email ID'])->label(false) ?>
                                        <?= $form->field($model, 'phoneno')->widget(MaskedInput:: classname(), [
													'mask' => '9',
													'options' => ['placeholder' => 'Phone Number'],
													'clientOptions' => ['repeat' => 10, 'greedy' => false],
												])->label(false);
												?>
									   <?= $form->field($model, 'password')->passwordInput(['placeholder' => 'Password'])->label(false) ?>
									   <?= $form->field($model, 'password_repeat')->passwordInput(['placeholder' => "Confirm Passowrd"])->label(false) ?>
									   
									   <div class="button-box">
                                            <?= Html::submitButton(Yii::t('user', '<span>Register</span>'), ['class' => 'default-btn'])?>
                                        </div>
									<?php ActiveForm::end(); ?>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>