<?php

/*
 * This file is part of the Dektrium project.
 *
 * (c) Dektrium project <http://github.com/dektrium>
 *
 * For the full copyright and license information, please view the LICENSE.md
 * file that was distributed with this source code.
 */
/**
 * @var yii\web\View $this
 * @var dektrium\user\models\ResendForm $model
 */
use yii\helpers\Html;
use yii\helpers\Url;
use yii\widgets\ActiveForm;
use frontend\assets\AppAsset;

AppAsset::register($this);
$this->title = 'Request new confirmation message';
\Yii::$app->view->registerMetaTag([
    'name' => 'description',
    'content' => 'Request new confirmation message - Shubh Ratan',
]);
?>
<!-- Breadcrumb Area start -->
<section class="breadcrumb-area">
	<div class="container">
		<div class="row">
			<div class="col-md-12">
				<div class="breadcrumb-content">
					<h1 class="breadcrumb-hrading">Request new confirmation</h1>
					<ul class="breadcrumb-links">
						<li><?= Html::a("Home",['/site/index'])  ?></li>
						<li>Request new confirmation</li>
					</ul>
				</div>
			</div>
		</div>
	</div>
</section>
<!-- Breadcrumb Area End -->
<!-- login area start -->
<div class="login-register-area mb-60px mt-53px">
	<div class="container">
		<div class="row">
			<div class="col-lg-7 col-md-12 mx-auto">
				<div class="login-register-wrapper">
					<div class="login-register-tab-list nav">
						<a class="active" data-bs-toggle="tab" href="#lg1">
							<h4>Request new confirmation</h4>
						</a>
					</div>
					<div class="tab-content">
						<div id="lg1" class="tab-pane active">
							<div class="login-form-container">
								<div class="login-register-form">
									<?php $form = ActiveForm::begin([
										'id' => 'resend-form',
										'enableAjaxValidation' => true,
										'enableClientValidation' => false,
									]); ?>

									<?= $form->field($model, 'email')->textInput(['autofocus' => true, 'placeholder' => 'Enter Your Email ID'])->label(false) ?>

									<?= Html::submitButton(Yii::t('user', 'Continue'), ['class' => 'btn btn-primary btn-block']) ?><br>

									<?php ActiveForm::end(); ?>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>

