<?php

/*
 * This file is part of the Dektrium project.
 *
 * (c) Dektrium project <http://github.com/dektrium>
 *
 * For the full copyright and license information, please view the LICENSE.md
 * file that was distributed with this source code.
 */

use dektrium\user\widgets\Connect;
use dektrium\user\models\LoginForm;
use yii\helpers\Html;
use yii\widgets\ActiveForm;

/**
 * @var yii\web\View $this
 * @var dektrium\user\models\LoginForm $model
 * @var dektrium\user\Module $module
 */

$this->title = Yii::t('user', 'Explore Our India Admin Login');
$this->params['breadcrumbs'][] = $this->title;
?>

<?= $this->render('/_alert', ['module' => Yii::$app->getModule('user')]) ?>

<div class="login-box">
      <div class="login-logo">
		&nbsp;
      </div><!-- /.login-logo -->
      <div class="login-box-body login-header">
		<h1><?= Html::img(Yii::$app->request->baseUrl.'/images/logo.png') ?></h1>
      </div>
      <div class="login-box-body">
  	
        <p class="login-box-msg"><?php echo Yii::t('app', 'Please fill out the following fields to login') ?></p>
		 <?php $form = ActiveForm::begin([
						'id' => 'login-form',
						'enableAjaxValidation' => true,
						'enableClientValidation' => false,
						'validateOnBlur' => false,
						'validateOnType' => false,
						'validateOnChange' => false,
						'fieldConfig' => [
								'template' => "{input}{error}",
							],
					]) ?>
          <div class="form-group has-feedback">
	          <?php if ($module->debug): ?>
                    <?= $form->field($model, 'login', [
                        'inputOptions' => [
                            'autofocus' => 'autofocus',
                            'class' => 'form-control',
                            'tabindex' => '1', 'placeholder'=>Yii::t('app', 'Email ID')]])->dropDownList(LoginForm::loginList());
                    ?>

                <?php else: ?>

                    <?= $form->field($model, 'login',
                        ['inputOptions' => ['autofocus' => 'autofocus', 'class' => 'form-control', 'tabindex' => '1', 'placeholder'=>Yii::t('app', 'Email ID')]]
                    );
                    ?>

                <?php endif ?>
            <span class="glyphicon glyphicon-user form-control-feedback"></span>
          </div>
          <div class="form-group has-feedback">
	         <?php if ($module->debug): ?>
                    <div class="alert alert-warning">
                        <?= Yii::t('user', 'Password is not necessary because the module is in DEBUG mode.'); ?>
                    </div>
                <?php else: ?>
                    <?= $form->field(
                        $model,
                        'password',
                        ['inputOptions' => ['class' => 'form-control', 'tabindex' => '2', 'placeholder'=>Yii::t('app', 'Password')]])
                        ->passwordInput()
                        ->label(
                            Yii::t('user', 'Password')
                            . ($module->enablePasswordRecovery ?
                                ' (' . Html::a(
                                    Yii::t('user', 'Forgot password?'),
                                    ['/user/recovery/request'],
                                    ['tabindex' => '5']
                                )
                                . ')' : '')
                        ) ?>
                <?php endif ?>
            <span class="glyphicon glyphicon-lock form-control-feedback"></span>
          </div>
          <div class="row">
            <div class="col-xs-7">    
              <div class="checkbox icheck">
		      <?= $form->field($model, 'rememberMe')->checkbox() ?>
              </div>                        
            </div><!-- /.col -->
            <div class="col-xs-5">
	      <?= Html::submitButton(Yii::t('app', 'Login'), ['class' => 'btn btn-primary btn-block btn-flat', 'name' => 'login-button']) ?>
            </div><!-- /.col -->
          </div>
       <?php ActiveForm::end(); ?>

        <!--a href="#">I forgot my password</a--><br>
      </div><!-- /.login-box-body -->
      <?php if(\Yii::$app->session->hasFlash('loginError')) : ?>
	    <div class="alert alert-danger alert-dismissible" style="margin-top: 5%;">
		<button type="button" class="close" data-dismiss="alert" aria-label="Close">
		<span aria-hidden="true">&times;</span></button>
		<?php echo \Yii::$app->session->getFlash('loginError'); ?>
	    </div>
       <?php endif; ?>
	   <?= Connect::widget([
            'baseAuthUrl' => ['/user/security/auth'],
        ]) ?>
    </div><!-- /.login-box -->
